#!/usr/bin/perl
########################################################################
#
#	File:			SkipStartup.pl
#
#	Description:	Skips through the setup app on a multilingual
#				ROM (after the language has been selected and
#				the "Are you sure..." dialog cleared).
#                      
#                        7/29/2004 update.  With the new Ace Simulator
#                        screens there are two more screens to get through
#                        in addition to the calibration.  The tap points
#                        coordinates changed and those are now reflected
#                        here. -- tbc
#
########################################################################

use lib "./Perl";

use EmRPC;			# EmRPC::OpenConnection, CloseConnection
use EmFunctions;
use EmUtils;		# TapPenSync, TapButtonSync


my $wRatio = 1;



sub main(@);
main (@ARGV);



########################################################################
# TWC
##
#
# Translate width cooridinates
# NOTE: We will use the width ratio
# for vertical translations too.
#
########################################################################

sub TWC($)
{
  my ($val) = @_;

  return $val * $wRatio;
}


########################################################################
# SkipStartup
##
#
# This is where we tap our way through the startup screens.
#
########################################################################

sub SkipStartup()
{
  OpenConnection ("localhost:2000#Console");

  # Tap the digitizer calibration targets
 
  TapPenSync (TWC(150), TWC(150));
  TapPenSync (TWC(15), TWC(15));
  TapPenSync (TWC(80), TWC(80));

  # Tap 'OK'
  TapPenSync (TWC(20), TWC(150)); sleep 1;
  # Now Tap 'Done'
  TapPenSync (TWC(60), TWC(150)); sleep 1;

  # Tap 'OK'
  # This will work around the Sprint startup problems...
  TapPenSync (TWC(80), TWC(150)); sleep 1;

  CloseConnection();
}


########################################################################
# main
##
#
# Main entry point for the script.
#
########################################################################

sub main(@)
{
  my ($height, $width) = @_;
  
  $wRatio = $width/160;

  SkipStartup (); 
}

1;